int rohwert;                // Variable "rohwert" vom Typ Integer (= Ganzzahlige Werte) wird angelegt
float spannung;             // Variable "spannung" vom Typ Float (= Fließkommazahl) wird angelegt
float temperatur;           // Variable "rohwert" vom Typ Float (= Fließkommazahl) wird angelegt


void setup() {

  
  Serial.begin(9600);       // Hier wird der serielle Monitor initialisiert (9600 Signaländerungen/Sekunde).
  
  pinMode (9, OUTPUT);      // Digitaler Pin 9 wird als OUTPUT festgelegt.
  pinMode (11, OUTPUT);     // Digitaler Pin 11 wird als OUTPUT festgelegt.

  pinMode (A0, INPUT);      // Analoger Pin 0 wird als INPUT festgelegt. Hier ist der Temperatursensor angeschlossen.
                            // Analoge Pins geben einen Wert von 0 bis 1023 wieder (haben also eine Auflösung von 1024 Schritten). 
                            // Der Wer ist abhängig von der anliegenden Spannung: 0 = 0V und 1023 = 5V. Entsprechend muss umgerechnet werden.
  
  }                         // Ende Setup


void loop() {
  
  rohwert = analogRead(A0);                 // Der Wert des analogen Pins 0 wird ausgelesen und der Variablen "rohwert" zugewiesen.

  Serial.print("Wert ");                    // Der Begriff "Wert" wird auf dem seriellen Monitor ausgegeben.
  Serial.println(rohwert);                  // Der Wert aus der Variablen "rohwert" wird auf dem seriellen Monitor ausgegeben und eine neue Zeile begonnen.
  
  spannung = (5.0 / 1024.0) * rohwert;      // Der Wert der Variable "rohwert" wird umgerechnet und in die Variable "spannung" geschrieben.
  temperatur =  ( spannung - .5 ) * 100;    // Der Wert der Variable "spannung" wird umgerechnet und in die Variable "temperatur" geschrieben.

  digitalWrite (9, HIGH);                   // Setzt den PIN 9 auf HIGH (5V) und schaltet damit die LED an,
  digitalWrite (11, HIGH);                  // Setzt den PIN 11 auf HIGH (5V) und schaltet damit die LED an
  delay (100);                              // Für 100ms warten
  
  digitalWrite (9, LOW);                    // Setzt den PIN 9 auf LOW (0V) und schaltet damit die LED aus
  digitalWrite (11, LOW);                   // Setzt den PIN 11 auf LOW (0V) und schaltet damit die LED aus
  delay (100);                              // Für 100ms warten


  }                                         // Ende Loop




/*  P5_Temperatursensor_14.05.2019
 
    **********************************************************
    AUFGABEN (Hinweise und Lösungen finden Sie am Ende!)
    **********************************************************

    1   VORBEREITUNG - Laden Sie dieses Programm unverändert auf den Aruino hoch. Wenn alles geklappt hat, blinken die LEDs. 


    2   AUSGABE AUF SERIELLEM MONITOR - Das Programm gibt Ihnen die Rohwerte des Temperatursensors auf dem seriellen Monitor aus. Lassen Sie sich diese Werte anzeigen, indem Sie den seriellen Monitor in der Arduino-IDE öffnen (--> Lupe oben rechts). 
        Beschriften Sie die Ausgabe auf dem seriellen Monitor (bspw. „Rohwert: <Wert>“) und fügen Sie eine Pause zwischen den einzelnen Ausgaben von einer halben Sekunde ein. 
      
        Prüfen Sie, wie sich die Werte ändern, wenn Sie den Sensor vorsichtig mit der Hand erwärmen und anschließend anpusten. Was sind die minimalen und die maximalen Werte für Spannung? Welcher Temperatur müssten diese entsprechen? Wie hoch ist die derzeitige Raumtemperatur?


    3   UMRECHNEN DER WERTE - Lassen Sie den Arduino die Spannungswerte in Temperaturwerte umrechnen und geben Sie diese gemeinsam mit dem Spannungswert auf dem seriellen Monitor aus: „Spannung: <WERT> - Temperatur: <WERT>“.
        Im Programm ist bereits eine Umrechung enthalten, diese ist aber noch nicht genau. Es wurden nur grobe Werte für das Verhältnis von Spannung und Temperatur sowie für den Offset eingesetzt. 
        Passen Sie diese Werte anhand des Datenblattes (Abbildung 3) an, um ein genaueres Ergebnis zu erhalten. Überprüfen Sie die Genauigkeit anhand einiger Referenz-Messungen mit z.B. Zimmertemperatur und Handtemperatur (37°C). 


    4   TEMPERATURWARNER - Programmieren Sie einen Temperaturwarner. Lassen Sie hierfür eine LED leuchten, wenn die Temperatur über 30° C steigt. Lassen Sie die andere LED leuchten, wenn die Temperatur unter 25° C sinkt.


    5   EXPORT UND IMPORT IN EXCEL - Erstellen Sie ein Zeit-Temperaturdiagramm mit mind. 20 Wertepaaren in Excel. Gehen Sie dafür folgendermaßen vor: 
        1. Passen Sie die Ausgabe der Werte auf dem Seriellen Monitor für den Export an. Lassen Sie sich z.B. einen Wert (ohne Einheit oder sonstige Informationen) pro Zeile ausgeben.
        2. Passen Sie die Ausgabe so an, dass ein Wert pro  Zeiteinheit (bspw. 1/4 Sekunde) geschrieben wird. Dies entspricht dann dem Messintervall. 
        3. Kopieren Sie die ausgegebenen Werte des seriellen Monitors direkt in Excel.
        4. Fügen Sie die Zeitinformation in Excel hinzu. Bei einem Messintervall von 1/4 Sekunde bspw. 0, 0,25, 0,5, 0,75, 1, usw.
        5. Erstellen Sie ein Zeit-Temperaturdiagramm und beschriften die Achsen.

        
    6   DIMMEN EINER LED - Nutzen Sie die Pulsweitenmodulation (PWM) und lassen Sie eine der LEDs bei verschiedenen Temperaturstufen verschieden hell leuchten.
        Verwenden Sie dazu den Befehl  >> analogWrite(9, 100); << und spielen Sie mit dem letzten Wert.

    
    **********************************************************
    LÖSUNGSHINWEISE
    **********************************************************


    4   TEMPERATURWARNER - LÖSUNGSHINWEISE
    
        - Nutzen Sie eine if-else-schleife

        if (temperatur > 30) {
        ... ; 
        }
        else {... ; }


    **********************************************************
    LÖSUNGEN
    **********************************************************
   
    3   UMRECHNEN DER WERTE - LÖSUNG
    
        Die korrekte Umrechnung für den TMP36 lautet: 

        Der Offset beträgt 0.5 und wird abgezogen, die Steigung beträgt 10mV pro °C, sodass mit 100 Multipliziert wird.
        
        temperatur =  ( spannung - .5 ) * 100;     

        
    5   EXPORT UND IMPORT IN EXCEL - LÖSUNG
        Nutzen Sie lediglich den folgenden Befehl für den seriellen Monitor und nur ein delay. 
        Alle anderen Befehle für den seriellen Monitor und delays müssen Auskommentiert werden.   
        Serial.println (Spannung1024);
        delay (250);   

    
*/
